#include "bits/stdc++.h"

//#define _GLIBCXX_DEBUG

//#pragma GCC optimize("O3")
//#pragma GCC optimize("Ofast")
//#pragma GCC optimize("unroll-loops")
//#pragma GCC target("avx2")

#define int long long
#define ll long long
#define ld long double
#define all(x) x.begin(), x.end()
#define rall(x) x.rbegin(), x.rend()
#define sz(x) (int)x.size()

using namespace std;

const ld EPS = 1e-10;

int sign(int x) {
    if (x > 0) return 1;
    if (x < 0) return -1;
    return 0;
}

int sign(ld x) {
    if (x > EPS) return 1;
    if (x < -EPS) return -1;
    return 0;
}

int sq(int x) {
    return x * x;
}

int sq(ld x) {
    return x * x;
}

struct Point {
    int x, y;

    Point() : x(0), y(0) {}

    Point(int _x, int _y) : x(_x), y(_y) {}

    Point operator+(const Point &other) const {
        return {x + other.x, y + other.y};
    }

    Point operator-(const Point &other) const {
        return {x - other.x, y - other.y};
    }

    Point operator*(int k) const {
        return {x * k, y * k};
    }

    ld operator*(const Point &other) const {
        return x * other.x + y * other.y;
    }

    ld operator%(const Point &other) const {
        return x * other.y - y * other.x;
    }

    friend istream& operator>>(istream& in, Point &other) {
        in >> other.x >> other.y;
        return in;
    }

    friend ostream& operator<<(ostream& out, Point other) {
        out << other.x << ' ' << other.y;
        return out;
    }
};

struct Line {
    int a, b, c;

    Line() : a(0), b(0), c(0) {}

    Line(int _a, int _b, int _c) : a(_a), b(_b), c(_c) {}

    Line(Point n, Point m) {
        a = m.y - n.y;
        b = n.x - m.x;
        c = n.y * m.x - m.y * n.x;
        if (sign(a) == -1) {
            a *= -1;
            b *= -1;
            c *= -1;
        }
        if (sign(a) == 0 && sign(b) == -1) {
            a *= -1;
            b *= -1;
            c *= -1;
        }
    }
};

pair<ld, ld> cross(Line n, Line m) {
    int d = m.a * n.b - n.a * m.b;
    return {(ld) (n.c * m.b - m.c * n.b) / d, (ld) (m.c * n.a - n.c * m.a) / d};
    //a1 * x + b1 * y + c1 = 0
    //a2 * x + b2 * y + c2 = 0
    //a1 * x * a2 + b1 * y * a2 + c1 * a2 = 0
    //a2 * x * a1 + b2 * y * a1 + c2 * a1 = 0
    //y * (b1 * a2 - b2 * a1) = c2 * a1 - c1 * a2
    //a1 * x * b2 + b1 * y * b2 + c1 * b2 = 0
    //a2 * x * b1 + b2 * y * b1 + c2 * b1 = 0
    //x(a2 * b1 - a1 * b2) = c1 * b2 - c2 * b1
}

bool check(int la, int ra, int lb, int rb) {
    return sign(min(ra, rb) - max(la, lb)) >= 0;
}

bool isCrossed(Point a, Point b, Point c, Point d) {
    if (!check(min(a.x, b.x), max(a.x, b.x), min(c.x, d.x), max(c.x, d.x))) return false;
    if (!check(min(a.y, b.y), max(a.y, b.y), min(c.y, d.y), max(c.y, d.y))) return false;
    Point v1 = b - a;
    Point v2 = c - a;
    Point v3 = d - a;
    if (sign(v1 % v2) * sign(v1 % v3) == 1) return false;
    v1 = d - c;
    v2 = a - c;
    v3 = b - c;
    if (sign(v1 % v2) * sign(v1 % v3) == 1) return false;
    return true;
}

struct cmp {
    bool operator()(const pair<ld, ld> &a, const pair<ld, ld> &b) const {
        if (sign(a.first - b.first) == 0) {
            return sign(a.second - b.second) < 0;
        }
        return sign(a.first - b.first) < 0;
    }
};

int cnt = 0;
vector<bool> used;
vector<vector<int>> g;
map<pair<ld, ld>, int, cmp> indexes;

void dfs(int v, int p) {
    used[v] = true;
    //cout << v << '\n';
    for (int &u: g[v]) {
        if (p == u || v == u) continue;
        if (used[u] == true) {
            //cout << "bad " << u << '\n';
            ++cnt;
        } else if (used[u] == false) {
            dfs(u, v);
        }
    }
}

void solve() {
    int n;
    cin >> n;
    vector<pair<Point, Point>> segments(n);
    vector<vector<pair<ld, ld>>> points(n);
    indexes = {};
    for (int i = 0; i < n; ++i) {
        cin >> segments[i].first >> segments[i].second;
        pair<ld, ld> need = make_pair((ld)segments[i].first.x, (ld)segments[i].first.y);
        points[i].emplace_back(need);
        if (indexes.find(need) == indexes.end()) {
            indexes[need] = sz(indexes);
            //cout << need.first << ' ' << need.second << ' ' << sz(index) - 1 << '\n';
        }
        need = make_pair((ld)segments[i].second.x, (ld)segments[i].second.y);
        points[i].emplace_back(need);
        if (indexes.find(need) == indexes.end()) {
            indexes[need] = sz(indexes);
            //cout << need.first << ' ' << need.second << ' ' << sz(index) - 1 << '\n';
        }
    }
    for (int i = 0; i < n; ++i) {
        Point a = segments[i].first, b = segments[i].second;
        for (int j = i + 1; j < n; ++j) {
            Point c = segments[j].first, d = segments[j].second;
            if (isCrossed(a, b, c, d)) {
                pair<ld, ld> cur = cross(Line(a, b), Line(c, d));
                points[i].emplace_back(cur);
                points[j].emplace_back(cur);
                if (indexes.find(cur) == indexes.end()) {
                    indexes[cur] = sz(indexes);
                    //cout << cur.first << ' ' << cur.second << ' ' << sz(index) - 1 << '\n';
                }
            }
        }
    }
    for (int i = 0; i < n; ++i) {
        sort(all(points[i]));
    }
    cnt = 0;
    vector<int> trash = {};
    g.assign(sz(indexes), trash);
    used.assign(sz(indexes), false);
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < sz(points[i]) - 1; ++j) {
            g[indexes[points[i][j]]].emplace_back(indexes[points[i][j + 1]]);
            g[indexes[points[i][j + 1]]].emplace_back(indexes[points[i][j]]);
        }
    }
    dfs(0, -1);
    cout << cnt / 2 + 1 << '\n';
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int tt = 1;
    cin >> tt;
    while (tt--) {
        solve();
    }
    return 0;
}
